﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace WindowsApplication4_selfcreate
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        //Form1_Load内で生成したオブジェクトを保持できるよう
        //メソッドの外側に設置
        Button button = null;
        TextBox textBox = null;

        //初期化メソッド
        private void Form1_Load(object sender, EventArgs e)
        {
            //ボタンの生成（）
            button = new Button();
            
            //表示テキストの設定
            button.Text = "Dispose";
            
            //位置とサイズの設定
            //どちらも、X,Y,Width,Heightなど、中の値
            //は読み取り専用になっている
            //そのため、それらを包括しているLocation,Size
            //自体を丸ごと作って入れる必要がある
            button.Location = new Point(50, 150);
            button.Size = new Size(200, 50);
            
            //フォームにbuttonを所属させる
            //この作業を行わないと、buttonは描画されない
            //位置の設定はこの後でも前でも問題ない
            this.Controls.Add(button);
            
            //クリック時のイベントの登録
            // +=で登録するのは、複数のイベントを登録できるため
            // 一回のクリックで複数のイベントを同時に起動させることも可能
            button.Click += new EventHandler(button_Click);

            
            
            //テキストボックスの生成
            textBox = new TextBox();
            textBox.Location = new Point(50,50);
            textBox.Size = new Size(200,50);
            //フォームにtextboxを所属させる
            this.Controls.Add(textBox);
        }

        //ボタンを押したときのイベントメソッド
        private void button_Click(object sender, EventArgs e) 
        {
            //sender  
            // イベントを発生させたコントロールが格納されている
            // この場合はボタンを押したのでsender == button
            //e
            // 状態を確認するための情報がつまっている
            // この場合はあまり意味がないが、MouseEventArgsで
            // あればクリックした位置などがe.Xといった形で取得できる

            //ボタンとテキストボックスの破棄
            textBox.Dispose();
            button.Dispose();
        }
    }
}