﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
//ファイルとかの入出力系のものがつまってる
using System.IO;

namespace WindowsApplication5_picturebox
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        //描画用クラス
        //これらは自動的には破棄されないので、本来なら
        //各メソッド内で定義して、描画終了時に破棄する
        //　関連ワーオ：using / try～finish
        Graphics _graphics = null;
        Pen _pen = null;
        Brush _brush = null;

        //描画メソッド
        private void pictureBox1_MouseDown(object sender, MouseEventArgs e)
        {
            this._graphics.DrawRectangle(this._pen, e.X, e.Y, 5, 5);
            
            //画面を更新
            //これがないと描画結果が画面に反映されない
            //　関連ワーオ：Application.DoEvent()
            this.pictureBox1.Refresh();
        }

        //画像の読み込みと表示メソッド
        private void buttonLoad_Click(object sender, EventArgs e)
        {
            if (openFileDialog1.ShowDialog() == DialogResult.OK) 
            {
                //選択したファイルのパスを取得
                string path = openFileDialog1.FileName;
                if (File.Exists(path) == true)
                {
                    //ファイルパスから画像読み込み
                    Bitmap drawimage = new Bitmap(path);
                    //Imageを書き込み、指定する座標は左上の座標
                    //矩形を指定して描画することも可能
                    //　関連ワーオ：Rectangle
                    this._graphics.DrawImage(drawimage, new Point(0,0));
                    this.pictureBox1.Refresh();
                }
            }
        }

        //画像の削除メソッド
        private void buttonDelete_Click(object sender, EventArgs e)
        {
            //指定した背景で塗りつぶし
            this._graphics.Clear(this.pictureBox1.BackColor);

            //画面を更新
            this.pictureBox1.Refresh();
        }

        //初期化イベントメソッド
        private void Form1_Load(object sender, EventArgs e)
        {
            //ピクチャボックスの初期化
            //Imageに画像を設定していない場合は、自分で初期化する必要がある
            //この場合はサイズだけ設定したビットマップを生成している
            this.pictureBox1.Image = new Bitmap(this.pictureBox1.Width, this.pictureBox1.Height);

            //グラフィクスクラスの初期化
            //キャンバスとなるImageクラスを設定することで生成できる
            //今回は、ピクチャボックスに描画するので、そのImageを引数に渡している
            this._graphics = Graphics.FromImage(this.pictureBox1.Image);

            //ペンの初期化
            //線を描画するときに使う
            //色と線の太さを設定
            this._pen = new Pen(Color.Red,1.0f);

            //ブラシの初期化
            //塗りつぶしを行う際に使う
            //色を指定
            this._brush = new SolidBrush(Color.Red);

        }



    }
}