﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace WindowsApplication7_randomhistory
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }
        const int LOOP_LIMIT = 100; 
        private void buttonOutput_Click(object sender, EventArgs e)
        {
            int min = int.Parse(this.textBoxMin.Text);
            int max = int.Parse(this.textBoxMax.Text);
            int seed1 = int.Parse(this.textBoxSeed1.Text);
            int seed2 = int.Parse(this.textBoxSeed2.Text);

            //乱数を種を指定して初期化
            Random random1 = new Random(seed1);
            //リストボックスのアイテムを初期化
            this.listBox1.Items.Clear();
            //乱数の系列を生成
            for (int row = 0; row < LOOP_LIMIT; row++) 
            {
                //乱数を生成
                //乱数は種に依存した計算を行う
                //種が決まった時点で乱数の系列は決まり
                //後はその系列を次々に取り出すないし計算して
                //ランダムな値を取り出しているように見せる
                //次に進めるというNextの名前の意味はこれ・・・のはず
                this.listBox1.Items.Add(random1.Next(min, max).ToString());
            }
            Random random2 = new Random(seed2);
            this.listBox2.Items.Clear();
            for (int row = 0; row < LOOP_LIMIT; row++)
            {
                this.listBox2.Items.Add(random2.Next(min, max).ToString());
            }

            if (seed1 == seed2)
            {
                MessageBox.Show("乱数の種seed1とseed2が同じであるため、同じ乱数の系列が作成されました。\n種を変えた場合も試してみて下さい");
            }
            else 
            {
                MessageBox.Show("乱数の種seed1とseed2が異なるため、違う乱数の系列が作成されました。");
            }
        }
    }
}