﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

//Nodeを定義したNetSim名前空間を読み込む
using NetSim;

namespace WindowsApplication8_node
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }
        //ノードの色
        Color _nodeColor = Color.Red;

        //フォント
        Font _font = null;

        //ノードを格納したリスト
        List<Node> _listNode = null;
        Size _sizeNode = new Size(15,15);

        private void Form1_Load(object sender, EventArgs e)
        {
            this.pictureBox1.Image = new Bitmap(this.pictureBox1.Width, this.pictureBox1.Height);

            //リストの初期化は List<要素の型>()となる
            //初見だと違和感バリバリかと思われるが
            //List<> までが型名であると考えれば
            //TextBox () と変わらない
            this._listNode = new List<Node>();

            this._font = new Font("MS明朝",9,FontStyle.Regular);
            
        }

        //ピクチャボックスのクリック時の動作
        private void pictureBox1_MouseUp(object sender, MouseEventArgs e)
        {
            //ノードの生成
            Node node = new Node(new Point(e.X, e.Y), this._sizeNode);

            //リストにノードを追加
            //配列と異なり、要素数は可変
            this._listNode.Add(node);

            //チェックドリストボックスにノードを追加
            this.checkedListBoxNode.Items.Add(this._listNode.Count-1);
            this.checkedListBoxNode.SetItemChecked(this.checkedListBoxNode.Items.Count - 1, true);

            //ノードを描画
            this.DrawCheckedNode();
            
        }

        //チェックされているノードを全て描画
        private void DrawCheckedNode() 
        {
            //グラフィクスで描画
            //usingステートメントを利用し、描画終了時のグラフィクスとペンの破棄を保証している
            using (Graphics graphics = Graphics.FromImage(this.pictureBox1.Image))
            using (Pen pen = new Pen(this._nodeColor))
            using (Brush brush = new SolidBrush(this._nodeColor))
            {
                graphics.Clear(this.pictureBox1.BackColor);
                for (int index = 0; index < this._listNode.Count; index++)
                {
                    if (this.checkedListBoxNode.GetItemChecked(index) == true)
                    {
                        graphics.DrawRectangle(pen, new Rectangle(
                             this._listNode[index]._location.X,
                             this._listNode[index]._location.Y,
                             this._listNode[index]._size.Width,
                             this._listNode[index]._size.Height)
                             );
                        graphics.DrawString(index.ToString(),
                            this._font, brush, this._listNode[index]._location);
                    }
                }
            }
            this.pictureBox1.Refresh();
        }

        
        //チェックドリストボックスがマウスボダンを押したとき
        //再描画（本来はチェック状態はダブルクリックしないと変わらないため、それにあわせた方がよい）
        private void checkedListBoxNode_MouseDown(object sender, MouseEventArgs e)
        {
            this.DrawCheckedNode();
        }
        //チェックドリストボックスでマウスボタンを離したとき
        //こちら側でも判定しないと、描画の更新とチェック項目の更新がずれる
        private void checkedListBoxNode_MouseUp(object sender, MouseEventArgs e)
        {
            this.DrawCheckedNode();
        }


    }
}