﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

//Nodeを定義したNetSim名前空間を読み込む
using NetSim;
using System.IO;

namespace WindowsApplication8_node
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }
        //ノードの色／文字の色／リンクの色
        Color _nodeColor = Color.Red;
        Color _stringColor = Color.White;
        Color _lineColor = Color.Red;
        //フォント
        Font _font = null;

        //ノードを格納したリスト
        List<Node> _listNode = null;
        Size _sizeNode = new Size(20,20);

        private void Form1_Load(object sender, EventArgs e)
        {
            this.pictureBox1.Image = new Bitmap(this.pictureBox1.Width, this.pictureBox1.Height);

            this._listNode = new List<Node>();

            this._font = new Font("MS明朝",9,FontStyle.Bold);
            
        }

        //ピクチャボックスのクリック時の動作
        //ノード追加
        //チェックドリストに追加
        //コンボボックスに追加
        private void pictureBox1_MouseUp(object sender, MouseEventArgs e)
        {
            //ノードの生成
            Node node = new Node(new Point(e.X, e.Y), this._sizeNode);

            //リストにノードを追加
            //配列と異なり、要素数は可変
            this._listNode.Add(node);

            if (this._listNode.Count > 0)
            {
                this._listNode[0].RegisterNode(node);
            }

            //チェックドリストボックスにノードを追加
            this.checkedListBoxNode.Items.Add(this._listNode.Count-1);
            this.checkedListBoxNode.SetItemChecked(this.checkedListBoxNode.Items.Count - 1, true);

            //コンボボックスにノード追加
            this.comboBoxSrc.Items.Add(this._listNode.Count-1);
            this.comboBoxDest.Items.Add(this._listNode.Count-1);

            //ノードを描画
            this.DrawCheckedNode();
            
        }

        //チェックされているノードを全て描画
        private void DrawCheckedNode() 
        {
            //グラフィクスで描画
            //usingステートメントを利用し、描画終了時のグラフィクスとペンの破棄を保証している
            using (Graphics graphics = Graphics.FromImage(this.pictureBox1.Image))
            using (Pen pen_line = new Pen(this._lineColor))
            using (Brush brush_string = new SolidBrush(this._stringColor))
            using (Brush brush = new SolidBrush(this._nodeColor))
            {
                graphics.Clear(this.pictureBox1.BackColor);
                for (int index = 0; index < this._listNode.Count; index++)
                {
                    if (this.checkedListBoxNode.GetItemChecked(index) == true)
                    {
                        //ノード（矩形）の描画
                        graphics.FillRectangle(brush, new Rectangle(
                             this._listNode[index]._location.X,
                             this._listNode[index]._location.Y,
                             this._listNode[index]._size.Width,
                             this._listNode[index]._size.Height)
                             );

                        //ノードIDの描画
                        //文字の幅を計算して中心揃えを追加
                        //簡単のためループ中でPointを生成しているが
                        //パフォーマンスを気にするような場合はループ中にnewしてはいけない
                        int width = (int)graphics.MeasureString(index.ToString(), this._font).Width;
                        int height = (int)graphics.MeasureString(index.ToString(), this._font).Height;
                        int padding_x = (this._sizeNode.Width - width)/2 ;
                        int padding_y = (this._sizeNode.Height - height)/2 ;
                        Point point = new Point(this._listNode[index]._location.X + padding_x, this._listNode[index]._location.Y+padding_y);
                        graphics.DrawString(index.ToString(),
                            this._font, brush_string, point);

                        //親ノードがいる場合は線で結ぶ
                        if (this._listNode[index]._parentNode != null) 
                        {
                            Point src_point = this._listNode[index]._location;
                            Point dest_point = this._listNode[index]._parentNode._location;

                            graphics.DrawLine(pen_line, src_point, dest_point);
                        }
                    }
                }
            }
            this.pictureBox1.Refresh();
        }

        
        //チェックドリストボックスがマウスボダンを押したとき
        //再描画（本来はチェック状態はダブルクリックしないと変わらないため、それにあわせた方がよい）
        private void checkedListBoxNode_MouseDown(object sender, MouseEventArgs e)
        {
            this.DrawCheckedNode();
        }
        //チェックドリストボックスでマウスボタンを離したとき
        //こちら側でも判定しないと、描画の更新とチェック項目の更新がずれる
        private void checkedListBoxNode_MouseUp(object sender, MouseEventArgs e)
        {
            this.DrawCheckedNode();
        }

        //親ノードの設定
        private void buttonSetParentNode_Click(object sender, EventArgs e)
        {
            if (this.comboBoxSrc.Text != "" && this.comboBoxDest.Text != "")
            {
                //追加するノードを取得（子）
                int src_index = int.Parse(this.comboBoxSrc.Text);
                Node src_node = this._listNode[src_index];
                //追加先のノードを取得（親）
                int dest_index = int.Parse(this.comboBoxDest.Text);
                Node dest_node = this._listNode[dest_index];

                //子を親に登録
                dest_node.RegisterNode(src_node);
                //再描画
                this.DrawCheckedNode();
            }
        }

        
        //ファイル読み込み(TODO)
        //
        //ex) インデックス5,設置座標（50,100）,親なし、子なし
        //index,5
        //x,50
        //y,100
        //parent,null
        //child_num,0
        //
        //ex) インデックス1,設置座標（50,100）,親1、子2
        //index,1
        //x,50
        //y,150
        //parent,0
        //child_num,2
        //child0,2
        //child1,3
        private void loadToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (openFileDialog1.ShowDialog() == DialogResult.OK) 
            {
                string path = openFileDialog1.FileName;

                StreamReader reader = new StreamReader(path,Encoding.UTF8);
                string line = "";
                line = reader.ReadLine();
                for(;;)
                {
                    
                }
            }
        }

        //終了
        private void exitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.Close();
        }

    }
}