/*
 * MyApp_SensorM.nc
 */
 
includes sensorboardApp;

/**
 * This module shows how to use the Timer, LED, ADC and Messaging components.
 * Sensor messages are broadcast single-hop over the RF radio
 *
 * @author Crossbow Technology Inc.
 **/


//#define ADDR TOS_LOCAL_ADDRESS?TOS_BCAST_ADDR:TOS_UART_ADDR
#define ADDR TOS_UART_ADDR

module MyAppM {
  provides {
    interface StdControl;
  }
  uses {
  interface Leds;
	interface SendMsg;
	interface ReceiveMsg;
    }
}
implementation {
//#define DBG_PKT 1
//#define SO_DEBUG 1
//#include <sodebug.h>



  norace bool sending_packet;
  norace bool receive_packet;
 
  TOS_Msg receive_buffer;
  XDataMsg *pack;
 
  
/*--Task--*/
  task void sendUART();

  /**
   * Initialize the component.
   * 
   * @return Always returns <code>SUCCESS</code>
   **/
  command result_t StdControl.init() {

    call Leds.init(); 


    // Initialize the message packet with default values
    atomic {
	  sending_packet = FALSE;
	  receive_packet = FALSE;
	}
    return SUCCESS;
  }

  /**
   * Start things up.  This just sets the rate for the clock component.
   * 
   * @return Always returns <code>SUCCESS</code>
   **/
  command result_t StdControl.start() {

	return SUCCESS;
  }

  /**
   * Halt execution of the application.
   * This just disables the clock component.
   * 
   * @return Always returns <code>SUCCESS</code>
   **/
  command result_t StdControl.stop() {

	return SUCCESS;
  }

  /**
   * Sensor data message has been sucessfully sent over the radio
   * Toggle green LED to signal message sent
   *
   * @return Always returns <code>SUCCESS</code>
   **/ 
  event result_t SendMsg.sendDone(TOS_MsgPtr msg, result_t success) {
    call Leds.greenToggle();
    atomic sending_packet = FALSE;

	if(receive_packet){
		post sendUART();
		receive_packet = FALSE;	
    }
	return SUCCESS;
  }

  event TOS_MsgPtr ReceiveMsg.receive(TOS_MsgPtr m){
	atomic {
		receive_buffer = *m;
		receive_packet = TRUE;
	}
	
	post sendUART();
		
	call Leds.yellowToggle();

	return m;
  }
  task void sendUART(){
	if (!sending_packet){
		atomic	sending_packet = TRUE;

		// Send message over radio
		if (call SendMsg.send(ADDR,sizeof(XDataMsg),&receive_buffer) != SUCCESS) sending_packet = FALSE;

	}

	return;
  }
}


