/*
 * MyApp.nc
 */
 
includes sensorboardApp;

/**
 * This configuration shows how to use the Timer, LED, ADC and Messaging components.
 * Sensor messages are broadcast single-hop over the RF radio
 *
 * @author Crossbow Technology Inc.
 **/
configuration MyApp {
}
implementation {
  components Main, MyAppM, TimerC, LedsC, Voltage,PhotoTemp, MicC,GenericComm as Comm;
  
  Main.StdControl -> TimerC.StdControl;
  Main.StdControl -> MyAppM.StdControl;
  Main.StdControl -> Comm.Control;
  
  MyAppM.Timer -> TimerC.Timer[unique("Timer")];

  MyAppM.Leds -> LedsC.Leds;
  
  MyAppM.BattControl -> Voltage;  
  MyAppM.ADCBATT -> Voltage;  
  
  MyAppM.PhotoControl -> PhotoTemp.PhotoStdControl;
  MyAppM.Light -> PhotoTemp.ExternalPhotoADC;

  MyAppM.TempControl -> PhotoTemp.TempStdControl;
  MyAppM.Temperature -> PhotoTemp.ExternalTempADC;

  MyAppM.MicControl -> MicC;
  MyAppM.MicADC -> MicC;
  MyAppM.Mic -> MicC;

  MyAppM.SendMsg -> Comm.SendMsg[AM_XMULTIHOP_MSG];
  MyAppM.ReceiveMsg -> Comm.ReceiveMsg[AM_XMULTIHOP_MSG];
  
}
