// $Id: sensorboardApp.h,v 1.2.4.3 2006/11/27 02:45:00 chenrl Exp $
/* sensorboard.h - hardware specific definitions for the MTS300/310 
*/

/*
TOSH_ALIAS_PIN(PHOTO_CTL, INT1);
TOSH_ALIAS_PIN(TEMP_CTL, INT2);

enum {
  TOSH_ACTUAL_PHOTO_PORT = 1,
  TOSH_ACTUAL_TEMP_PORT = 1, 
};

enum {
  TOS_ADC_PHOTO_PORT = 1,
  TOS_ADC_TEMP_PORT = 2,
};

*/

#define FEATURE_SOUNDER     1

// Define SOUND_STATE_CHANGE one of two ways:
//      One time sound at test init   ==>  FALSE
//      Continuous beeping throughout ==>  !sound_state
#define SOUND_STATE_CHANGE  FALSE
//#define SOUND_STATE_CHANGE  !sound_state

// crossbow sensor board id
//#define  SENSOR_BOARD_ID 0x88               //XTYPE_XTUTORIAL=0x88
#define MTS310
#ifndef MTS310
#define  SENSOR_BOARD_ID 0x83               //MTS300 sensor board id
#else
#define  SENSOR_BOARD_ID 0x84               //MTS310 sensor board id
#endif

typedef struct XSensorHeader{
  uint8_t  board_id;
  uint8_t  packet_id; // 3
//  uint8_t  node_id;
  uint8_t  measurement;
  uint8_t  priority;
}__attribute__ ((packed)) XSensorHeader;

typedef struct XSensorData {
  uint16_t vref;
  uint16_t thermistor;
  uint16_t light;
  uint16_t mic;
/*uint16_t accelX;
  uint16_t accelY;
  uint16_t magX;
  uint16_t magY;*/
} __attribute__ ((packed)) XSensorData;

typedef struct IdHeader{
  uint16_t dest_id;		//!< Node that last sent this message.
  uint16_t node_id;		//!< Node that owns message (source or final destination).
  uint16_t seqno;		//!< XMesh sequence number for link estimation.
  uint8_t  app_id;	
 }__attribute__ ((packed)) IdHeader;
 
typedef struct Time{
  uint16_t seqno;
  uint32_t sense;
  uint16_t delay;
  uint16_t delay2;
}__attribute__ ((packed)) Time;
 
typedef struct XDataMsg {
  IdHeader idHeader;
  XSensorHeader xSensorHeader;
  XSensorData   xSensorData;
  Time	time;
} __attribute__ ((packed)) XDataMsg;

enum {
  AM_XMULTIHOP_MSG = 51,
 };
